BEGIN
  SYS.DBMS_SCHEDULER.DROP_JOB
    (job_name  => 'ADR.BATCH_ACA_PROCESSED_JOB');
END;
/

BEGIN
  SYS.DBMS_SCHEDULER.CREATE_JOB
    (
       job_name        => 'ADR.BATCH_ACA_PROCESSED_JOB'
      ,start_date      => TO_TIMESTAMP_TZ('2017/10/24 14:00:00.000000 -05:00','yyyy/mm/dd hh24:mi:ss.ff tzr')
      ,repeat_interval => 'FREQ=DAILY'
      ,end_date        => NULL
      ,job_class       => 'DEFAULT_JOB_CLASS'
      ,job_type        => 'STORED_PROCEDURE'
      ,job_action      => 'ADR.BATCH_ACA_PROCESSED_SP'
      ,comments        => NULL
    );
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.BATCH_ACA_PROCESSED_JOB'
     ,attribute => 'RESTARTABLE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.BATCH_ACA_PROCESSED_JOB'
     ,attribute => 'LOGGING_LEVEL'
     ,value     => SYS.DBMS_SCHEDULER.LOGGING_OFF);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.BATCH_ACA_PROCESSED_JOB'
     ,attribute => 'MAX_FAILURES');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.BATCH_ACA_PROCESSED_JOB'
     ,attribute => 'MAX_RUNS');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.BATCH_ACA_PROCESSED_JOB'
     ,attribute => 'STOP_ON_WINDOW_CLOSE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.BATCH_ACA_PROCESSED_JOB'
     ,attribute => 'JOB_PRIORITY'
     ,value     => 3);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.BATCH_ACA_PROCESSED_JOB'
     ,attribute => 'SCHEDULE_LIMIT');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.BATCH_ACA_PROCESSED_JOB'
     ,attribute => 'AUTO_DROP'
     ,value     => FALSE);

  SYS.DBMS_SCHEDULER.ENABLE
    (name                  => 'ADR.BATCH_ACA_PROCESSED_JOB');
END;
/
BEGIN
  SYS.DBMS_SCHEDULER.DROP_JOB
    (job_name  => 'ADR.CCN_SRV_LOAD_JOB');
END;
/

BEGIN
  SYS.DBMS_SCHEDULER.CREATE_JOB
    (
       job_name        => 'ADR.CCN_SRV_LOAD_JOB'
      ,start_date      => TO_TIMESTAMP_TZ('2018/08/13 13:43:13.496768 CST6CDT','yyyy/mm/dd hh24:mi:ss.ff tzr')
      ,repeat_interval => 'FREQ=DAILY;BYHOUR=10;BYMINUTE=0;BYSECOND=0'
      ,end_date        => NULL
      ,job_class       => 'DEFAULT_JOB_CLASS'
      ,job_type        => 'PLSQL_BLOCK'
      ,job_action      => ' BEGIN ADR.CCN_SRV_LOAD_PKG.SET_BULK_LOAD_LIMIT(50000);
ADR.CCN_SRV_LOAD_PKG.SET_DOP(4);
ADR.CCN_SRV_LOAD_PKG.PROCESS_CCN_SERVICE_LOG_MAIN;
END;'
      ,comments        => NULL
    );
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CCN_SRV_LOAD_JOB'
     ,attribute => 'RESTARTABLE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CCN_SRV_LOAD_JOB'
     ,attribute => 'LOGGING_LEVEL'
     ,value     => SYS.DBMS_SCHEDULER.LOGGING_OFF);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.CCN_SRV_LOAD_JOB'
     ,attribute => 'MAX_FAILURES');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.CCN_SRV_LOAD_JOB'
     ,attribute => 'MAX_RUNS');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CCN_SRV_LOAD_JOB'
     ,attribute => 'STOP_ON_WINDOW_CLOSE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CCN_SRV_LOAD_JOB'
     ,attribute => 'JOB_PRIORITY'
     ,value     => 3);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.CCN_SRV_LOAD_JOB'
     ,attribute => 'SCHEDULE_LIMIT');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CCN_SRV_LOAD_JOB'
     ,attribute => 'AUTO_DROP'
     ,value     => TRUE);

  SYS.DBMS_SCHEDULER.ENABLE
    (name                  => 'ADR.CCN_SRV_LOAD_JOB');
END;
/
BEGIN
  SYS.DBMS_SCHEDULER.DROP_JOB
    (job_name  => 'ADR.CLEAN_SSN_FRM_ADDR_JOB');
END;
/

BEGIN
  SYS.DBMS_SCHEDULER.CREATE_JOB
    (
       job_name        => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
      ,start_date      => TO_TIMESTAMP_TZ('2017/09/19 17:00:00.000000 -05:00','yyyy/mm/dd hh24:mi:ss.ff tzr')
      ,repeat_interval => 'FREQ=MONTHLY; BYDAY=-1 SUN'
      ,end_date        => NULL
      ,job_class       => 'DEFAULT_JOB_CLASS'
      ,job_type        => 'STORED_PROCEDURE'
      ,job_action      => 'ADR.CLEAN_SSN_FRM_ADDR'
      ,comments        => NULL
    );
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'RESTARTABLE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'LOGGING_LEVEL'
     ,value     => SYS.DBMS_SCHEDULER.LOGGING_OFF);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'MAX_FAILURES');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'MAX_RUNS');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'STOP_ON_WINDOW_CLOSE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'JOB_PRIORITY'
     ,value     => 3);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'SCHEDULE_LIMIT');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'AUTO_DROP'
     ,value     => FALSE);

  SYS.DBMS_SCHEDULER.ENABLE
    (name                  => 'ADR.CLEAN_SSN_FRM_ADDR_JOB');
END;
/
BEGIN
  SYS.DBMS_SCHEDULER.DROP_JOB
    (job_name  => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1');
END;
/

BEGIN
  SYS.DBMS_SCHEDULER.CREATE_JOB
    (
       job_name        => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1'
      ,start_date      => TO_TIMESTAMP_TZ('2017/12/13 14:00:00.000000 -05:00','yyyy/mm/dd hh24:mi:ss.ff tzr')
      ,repeat_interval => 'FREQ=YEARLY'
      ,end_date        => NULL
      ,job_class       => 'DEFAULT_JOB_CLASS'
      ,job_type        => 'PLSQL_BLOCK'
      ,job_action      => 'BEGIN LOAD_CORRESPONDENCE_INFO_SP(1000,TRUNC(SYSDATE,''YEAR'')); END;'
      ,comments        => NULL
    );
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1'
     ,attribute => 'RESTARTABLE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1'
     ,attribute => 'LOGGING_LEVEL'
     ,value     => SYS.DBMS_SCHEDULER.LOGGING_OFF);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1'
     ,attribute => 'MAX_FAILURES');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1'
     ,attribute => 'MAX_RUNS');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1'
     ,attribute => 'STOP_ON_WINDOW_CLOSE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1'
     ,attribute => 'JOB_PRIORITY'
     ,value     => 3);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1'
     ,attribute => 'SCHEDULE_LIMIT');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1'
     ,attribute => 'AUTO_DROP'
     ,value     => FALSE);

  SYS.DBMS_SCHEDULER.ENABLE
    (name                  => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB1');
END;
/
BEGIN
  SYS.DBMS_SCHEDULER.DROP_JOB
    (job_name  => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2');
END;
/

BEGIN
  SYS.DBMS_SCHEDULER.CREATE_JOB
    (
       job_name        => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2'
      ,start_date      => TO_TIMESTAMP_TZ('2018/01/01 14:00:00.000000 -05:00','yyyy/mm/dd hh24:mi:ss.ff tzr')
      ,repeat_interval => 'FREQ=YEARLY'
      ,end_date        => NULL
      ,job_class       => 'DEFAULT_JOB_CLASS'
      ,job_type        => 'PLSQL_BLOCK'
      ,job_action      => 'BEGIN LOAD_CORRESPONDENCE_INFO_SP(1000,TRUNC(SYSDATE-7,''YEAR'')); END;'
      ,comments        => NULL
    );
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2'
     ,attribute => 'RESTARTABLE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2'
     ,attribute => 'LOGGING_LEVEL'
     ,value     => SYS.DBMS_SCHEDULER.LOGGING_OFF);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2'
     ,attribute => 'MAX_FAILURES');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2'
     ,attribute => 'MAX_RUNS');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2'
     ,attribute => 'STOP_ON_WINDOW_CLOSE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2'
     ,attribute => 'JOB_PRIORITY'
     ,value     => 3);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2'
     ,attribute => 'SCHEDULE_LIMIT');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2'
     ,attribute => 'AUTO_DROP'
     ,value     => FALSE);

  SYS.DBMS_SCHEDULER.ENABLE
    (name                  => 'ADR.LOAD_CORRESPONDENCE_INFO_JOB2');
END;
/
BEGIN
  SYS.DBMS_SCHEDULER.DROP_JOB
    (job_name  => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB');
END;
/

BEGIN
  SYS.DBMS_SCHEDULER.CREATE_JOB
    (
       job_name        => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
      ,start_date      => TO_TIMESTAMP_TZ('2017/07/25 11:00:00.000000 -05:00','yyyy/mm/dd hh24:mi:ss.ff tzr')
      ,repeat_interval => 'FREQ=DAILY'
      ,end_date        => NULL
      ,job_class       => 'DEFAULT_JOB_CLASS'
      ,job_type        => 'PLSQL_BLOCK'
      ,job_action      => 'BEGIN LOAD_MISSING_RESIDENT_ADDR_SP(1000); END;'
      ,comments        => NULL
    );
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'RESTARTABLE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'LOGGING_LEVEL'
     ,value     => SYS.DBMS_SCHEDULER.LOGGING_OFF);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'MAX_FAILURES');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'MAX_RUNS');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'STOP_ON_WINDOW_CLOSE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'JOB_PRIORITY'
     ,value     => 3);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'SCHEDULE_LIMIT');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'AUTO_DROP'
     ,value     => FALSE);

  SYS.DBMS_SCHEDULER.ENABLE
    (name                  => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB');
END;
/
